
// SC542N1_CallbackOnlyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC542N1_CallbackOnly.h"
#include "SC542N1_CallbackOnlyDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CSC542N1_CallbackOnlyDlg * pMainDlg = (CSC542N1_CallbackOnlyDlg *)(pUserData);

	if((nFrameBufferLen>0) && (pMainDlg->display == true))
	{
		CHAR psz[ MAX_PATH ];

		sprintf( psz, "INFO: nFrameBufferLen = %d, dSampleTime = %f", nFrameBufferLen, dSampleTime);

		pMainDlg->m_statInfo1.SetWindowText( psz );
	}

	return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CSC542N1_CallbackOnlyDlg * pMainDlg = (CSC542N1_CallbackOnlyDlg *)(pUserData);

	if((nFrameBufferLen>0) && (pMainDlg->display == true))
	{
		CHAR psz[ MAX_PATH ];

		sprintf( psz, "INFO: nFrameBufferLen = %d, dSampleTime = %f", nFrameBufferLen, dSampleTime);

		pMainDlg->m_statInfo0.SetWindowText( psz );
	}

    return QCAP_RT_OK;
}

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CSC542N1_CallbackOnlyDlg dialog




CSC542N1_CallbackOnlyDlg::CSC542N1_CallbackOnlyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSC542N1_CallbackOnlyDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSC542N1_CallbackOnlyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATIC_INFO_1, m_statInfo1);
	DDX_Control(pDX, IDC_STATIC_INFO_0, m_statInfo0);
}

BEGIN_MESSAGE_MAP(CSC542N1_CallbackOnlyDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
END_MESSAGE_MAP()


// CSC542N1_CallbackOnlyDlg message handlers

BOOL CSC542N1_CallbackOnlyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here


	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//
	m_pDevice = NULL;

	display = false;

	// INITIALIZE DEVICE RESOURCE
	//
	QCAP_CREATE( "QP0203 PCI", 0, NULL, &m_pDevice, TRUE );

	QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_audio_preview_callback, this );

	QCAP_SET_VIDEO_INPUT( m_pDevice, QCAP_INPUT_TYPE_AUTO );

	QCAP_SET_AUDIO_INPUT( m_pDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

	QCAP_RUN( m_pDevice );

	display = true;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSC542N1_CallbackOnlyDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC542N1_CallbackOnlyDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC542N1_CallbackOnlyDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CSC542N1_CallbackOnlyDlg::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO: Add your message handler code here

	display = false;

	if( m_pDevice ) {

		QCAP_STOP( m_pDevice );

		QCAP_DESTROY( m_pDevice );

		m_pDevice = NULL;
	}

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}
